* Title: 	figure3.do
* Version: 	23 May 2018
* Purpose: 	Produce graph of correlation joblessness and wage change


*******************************************************************************
* (0) Start of file
*******************************************************************************

capture log close
log using output/figures/log/figure14, text replace
set more off
clear all
macro drop _all


*******************************************************************************
* (1) Load data
*******************************************************************************

use year statefip conspuma PrimeMaleD UnempB incwage_real_ftfy_pos perwt ///
	using dta/census_clean, clear

* Keep only prime-age men
keep if PrimeMaleD == 1

* Keep only 1980 Census and 2009-2011 ACS
keep if year == 1980 | (year>=2009 & year<=2011)

* Pool data for 2009-2011 ACS
replace year = 2010 if year>=2009 & year<=2011

* Keep only continental 48 states (excluding District of Columbia)
drop if (statefip == 02 | statefip == 11 | statefip == 15 | statefip>56)

* Fix coding due to post-2006 PUMA change due to Katrina
replace conspuma = 172 if conspuma == 173


*******************************************************************************
* (2) Construct median income and joblessness variables for 1980/2010
*******************************************************************************

collapse 	(sum)	 Total = PrimeMaleD Jobless = UnempB ///
			(median) Wage_Median = incwage_real_ftfy_pos  ///
			[pw=perwt], by(year conspuma)

gen double Jobless_Rate	= Jobless / Total
gen Log_Wage_Median 	= log(Wage_Median)

keep year conspuma Jobless_Rate Log_Wage_Median
reshape wide Jobless_Rate Log_Wage_Median, i(conspuma) j(year)
gen Delta_Jobless_Rate 	= 100 * (Jobless_Rate2010 - Jobless_Rate1980)
gen Delta_LogWage		= Log_Wage_Median2010 - Log_Wage_Median1980
 

* Save dataset
keep conspuma Delta_*
compress
save output/figures/dta/figure14.dta, replace


*******************************************************************************
* (3) Produce regression/graph
*******************************************************************************

corr Delta_Jobless_Rate Delta_LogWage
reg Delta_Jobless_Rate Delta_LogWage


scatter Delta_Jobless_Rate Delta_LogWage || lfit Delta_Jobless_Rate Delta_LogWage, ///
		legend(label(1 "PUMA") label(2 "Best Fit")) ///
		graphregion(color(white)) bgcolor(white) ///
		xtitle("Change in log median wage, 1980-2010") ytitle("Change in not working rate, 1980-2010")

graph save output/figures/gph/figure14, replace
graph export output/figures/eps/figure14.eps, as(eps) replace
export excel using output/figures/xlsx/figure14.xlsx, first(variables) replace
	 
	 
*******************************************************************************
* (4) End of file
*******************************************************************************

log close
exit, clear
